; Copyright 1997-1998 by Henter-Joyce, Inc.
; Script file for Windows Help
;Copyright 1998, 1999 by Henter-Joyce, Inc.
; 6/18/98. A.G.
; Converted 3/17/97, cw
;Updated and modified 3/30/98 by D.B
include "winhlp32.jsm"
Include "hjconst.jsh"
Include "hjglobal.jsh"

globals
	HANDLE GlobalWinHlp32Handle,
	int IgnoreNewText		

Function AutoStartEvent ()
if (ToggleRestriction()) then
ToggleRestriction () ; turn restriction off
endif
EndFunction

Function AutoFinishEvent ()
PCCursor ()
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
string TheClass,
Handle rWin,
String rWinClass,
String rWinName
If (IgnoreNewText) then
	return 
Endif
let TheClass = GetWindowClass(hwnd)
Let rWin  = GetRealWindow (GetFocus())
Let rWinClass = GetWindowClass (rWin)
let rWinName = GetWindowName (rWin)
If (rWinClass == wcDialog) then
	Return
EndIf
;wn1="MS_WINTOPIC"
if ((TheClass==wn1) ||
;wn2="MS_WINNOTE"
(TheClass == wn2) ||
;wn3="MS_WINNSR"
(TheClass == wn3) ||
;wn4="MS_WINSR"
(TheClass == wn4)  ||
;wn5="#32771"
TheClass == wn5 ) then
Say (buffer, OT_BUFFER)
let GlobalWinHlp32Handle	= hwnd	
return
endif
;wn6="Static"
If (TheClass == wn6) then
;wn7="Find Setup Wizard"
	If (rWinName == wn7) then
		Say (buffer, OT_BUFFER)
		return
	EndIf
EndIf ;Class is static
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
if (GlobalPrevApp != AppWindow && AppWindow != FocusWindow) then
  ; we've switched to a different app main window,
  ; and it does not have the focus, so announce it
  SayWindowTypeAndText (AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
  || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
  If ((RealWindow != AppWindow) && (RealWindow != FocusWindow)) then
;    SayWindowTypeAndText (RealWindow)
  endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
  SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
  SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Void Function SayFocusedWindow ()
Var
	Handle rWin, String rWinClass,
	String cwClass, 
	Handle curWin, Handle hTarget
Let rWin  = GetRealWindow (GetFocus ())
Let rWinClass = GetWindowClass (rWin)
If (rWinClass == wcDialog)	Then
	Let curWin = GetCurrentWindow ()
	Let cwClass = GetWindowClass (curWin)
	If (cwClass == wc9) Then
		Let hTarget = GetPriorWindow (curWin)
		SayWindow (hTarget, READ_EVERYTHING)
		SayWindowTypeandText (GlobalFocusWindow)
		Return
	EndIf
EndIf
;wc13="SysTabControl32"
If ((GetWindowClass (GlobalPrevFocus) == wc13) &&
;wc9="SysTreeView32"
(GetWindowClass (GlobalFocusWindow) == wc9)) then
	SaveCursor ()
	InvisibleCursor()
	MoveToWindow (GetPriorWindow(GlobalFocusWindow))
	SayChunk()
EndIf
If (GetControlID (GlobalFocusWindow) == 1001) then
	Say (msg14, OT_MESSAGE) ;"Type the word or phrase you want to find"
	Say (msg15, OT_MESSAGE) ;"edit"
	return
EndIf
If (GetControlID (GlobalFocusWindow) == 6001) then
	Say (msg16, OT_MESSAGE) ;"Select some matching words to narrow your search"
	Say (msg17, OT_MESSAGE) ;"text viewer"
	return
EndIf
If (GetControlID (GlobalFocusWindow) == 6007) then
	Say (msg18, OT_MESSAGE) ;"Select a topic, and then select the display button"
	Say (msg17, OT_MESSAGE) ;"text viewer"
	return
EndIf
SayWindowTypeandText (GlobalFocusWindow)
EndFunction

Script  ScriptFileName()
ScriptAndAppNames ("Windows Help")
EndScript

Script ScreenSensitiveHelp ()
var
	String TheClass
Let TheClass = GetWindowClass (GetCurrentWindow ())
;wn22="ms_winnote"
if (TheClass == wn22) then
	Say (msg23, OT_HELP) ;"This is a Windows help note"
	Say (msg24, OT_HELP) ;"It contains help that is relevant to the current control"
	Say (msg25 + GetScriptKeyName ("SayHelpWindow") + " ", OT_HELP) ;"to reed this note with the jaws cursor use "
	Say (msg66, OT_HELP) ;"or control plus page down or page up to read the next or prior screen"
	Say (msg26, OT_HELP) ;"press escape or enter to return to the current application"
	return
endif
;wn27="ms_wintopic"
if (TheClass == wn27) then
	Say (msg28, OT_HELP) ;"This is a Windows help topic"
	Say (msg29, OT_HELP) ;"It contains help specific to a requested topic"
	Say (msg30 + GetScriptKeyName ("SayHelpWindow") + " ", OT_HELP) ;"to read this topic with the jaws cursor use "
	Say (msg66, OT_HELP) ;"or control plus page down or page up to read the next or prior screen"
	Say (msg31, OT_HELP) ;"press alt plus f4 to return to the current application"
	return
endif
;wn32="ms_winnsr"
if (TheClass == wn32) then
	Say (msg33, OT_HELP) ;"This is the jaws for windows  help title"
	Say (msg34, OT_HELP) ;"it generally contains a title for the current topic"
	return
endif
;wn35="ms_winhelp"
if (TheClass == wn35) then
	Say (msg67, OT_HELP) ;"This is a help window"
	Say (msg30 + GetScriptKeyName ("SayHelpWindow") + " ", OT_HELP); "to read this topic with the jaws cursor use "
	Say (msg66, OT_HELP) ;"or control plus page down or page up to read the next or prior screen"
	return
endif
PerformScript ScreenSensitiveHelp ()
EndScript

Script  HotKeyHelp()
var
	string WindowName,
	int TheTypeCode,
	string TheClass
let WindowName= GetWindowName (GetRealWindow (GetFocus ()))
let TheTypeCode = GetWindowTypeCode (GetCurrentWindow())
Let TheClass = GetWindowClass (GetCurrentWindow ())

if  (TheTypeCode == wt_unknown) then
;wn22="ms_winnote"
	if (TheClass == wn22) then
		Say (msg25+GetScriptKeyName ("SayHelpWindow"), OT_HELP) ;"to reed this note with the jaws cursor use control plus insert down arrow"
		return
	endif
;wn27="ms_wintopic"
;wn27b="ms_winhelp"
	if (TheClass == wn27b || TheClass == wn27) then
		Say (msg30+GetScriptKeyName ("SayHelpWindow"), OT_HELP) ;"to reed this topic with the jaws cursor use control plus insert down arrow"
		Say (msg25h+GetScriptKeyName("SayNextScreen"), OT_HELP);"to scroll down one page and reed with the JAWS cursor use "
		Say (msg25i+GetScriptKeyName("SayPriorScreen"), OT_HELP);"to scroll up one page and reed with the JAWS cursor use "
		Say (msg25b, OT_HELP);"to view help topics use t"
		Say (msg25c, OT_HELP);"to move to the prior help topic use b"
		Say (msg25d, OT_HELP);"to print this help topic use p"
		Say (msg25e, OT_HELP);"to open the options menu use o"
		Say (msg25f, OT_HELP);"to move backwards through the browse list use <"
		Say (msg25g, OT_HELP);"to move forward through the browse list use >"
		return
	endif
EndIf

If (GetWindowTypeCode (GetRealWindow (GetFocus ())) == wt_dialog) then
;wn39="Search"
	If (WindowName == wn39) then
		Say (msg40, OT_HELP) ;"Use the Tab key or the following Windows hot keys"
		Say (msg41, OT_HELP) ;"Type a word edit box with list use alt w"
		Say (msg42, OT_HELP) ;"Show topics button use alt s"
		Say (msg43, OT_HELP) ;"Go to button use alt g"
		Say (msg44, OT_HELP) ;"Press enter to accept the changes or press escape to cancel"
		Return
	EndIf
	HotKeyHelpDefaultLoop ()
Else
PerformScript HotKeyHelp()
endif
EndScript

Script SayTopicsFound ()
SaveCursor()
;fs46="Topics Found"
If FindString (GetFocus(), fs46, S_BOTTOM, S_UNRESTRICTED) then
	SayLine()
EndIf
RestoreCursor()
EndScript

Void Function SayHighlightedText (handle hwnd, string buffer)
if((GetScreenEcho() > 0) && (GetControlID (hwnd) != 6001) && (GetControlID (hwnd) != 6007)) Then
	Say (buffer, OT_BUFFER)
	Return
EndIf
if ((GetControlID (GetCurrentWindow ()) == 6001) && (GetControlID (hwnd) == 6001)) then
	Say (buffer, OT_BUFFER)
	return
endif
if ((GetControlID (GetCurrentWindow ()) == 6007) && (GetControlID (hwnd) == 6007)) then
	Say (buffer, OT_BUFFER)
endif
EndFunction

Script SayHelpWindow ()
	JAWSCursor()
	if (GlobalWinHlp32Handle	> 0) then	
		MoveToWindow (GlobalWinHlp32Handle)
		SayAll()
	endif		
EndScript

Script  SayPriorScreen()
let IgnoreNewText = TRUE
{PageUp} ; tell help to do page up
Pause()
let IgnoreNewText = FALSE
	JAWSCursor()
	if (GlobalWinHlp32Handle	> 0) then	
		MoveToWindow (GlobalWinHlp32Handle)
		SayAll()
	endif		
EndScript

Script  SayNextScreen()
let IgnoreNewText = TRUE
{PageDown} ; tell help to do page down
Pause()
let IgnoreNewText = FALSE
	JAWSCursor()
	if (GlobalWinHlp32Handle	> 0) then	
		MoveToWindow (GlobalWinHlp32Handle)
		SayAll()
	endif		
EndScript

Script NextControl ()
{tab}
pause()
if ((GetCharacterAttributes () & ATTRIB_GRAPHIC) == ATTRIB_GRAPHIC ) then
	SayChunk()
endif
EndScript

Script PriorControl ()
{shift+tab}
pause()
if ((GetCharacterAttributes () & ATTRIB_GRAPHIC) == ATTRIB_GRAPHIC ) then
	SayChunk()
endif
EndScript
